clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1011.dta, clear
capture log close
log using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\log_files\log_step4002.log, replace

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total



*==============================================================
*				Estimation sample
*==============================================================

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1  , robust beta 
			
keep if e(sample)


*==============================================================
*				Table 001: migration
*==============================================================


reg  ue2_hyst ///
			turnmig_rate ///
			[aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
	
outreg2  ///
			turnmig_rate ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			replace	dta ctitle("OLS") dec(2) nocons addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		+ controls 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			turnmig_rate   ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar(year_school hh_size home_own_rate  netmig_rate ///	(OTHER CONTROLS)	
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  /// (OTHER CONTROLS)
			logY_ppp   urban_share_500_y1990 mlog_road_density city_nuts capital /// (OTHER CONTROLS)
			turnmig_rate   mean_ue2_hyst_A  ///
			ue2_hyst_A_X_mob  mean_ue2_hyst_A_X_mob ///
			mean_turnmig_rate ///
			dev_ue2_hyst_A_X_mobA  ///
			)
			
			
			
			
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		controls only + FE
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			turnmig_rate ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("FE") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_14 share_age_15_24 share_age_55_64 share_age_65plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
			

*==============================================================
*				Table 001: demographics
*==============================================================


reg  ue2_hyst ///
			share_age_0_24 share_age_55plus ///
			[aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
	
outreg2  ///
			share_age_0_24 share_age_55plus ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("OLS") dec(2) nocons addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		+ controls 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			share_age_0_24 share_age_55plus ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			share_age_0_24 share_age_55plus   ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			share_age_0_24 share_age_55plus ///
			year_school hh_size home_own_rate  netmig_rate ///	(OTHER CONTROLS)	
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  /// (OTHER CONTROLS)
			logY_ppp   urban_share_500_y1990 mlog_road_density city_nuts capital /// (OTHER CONTROLS)
			turnmig_rate  ///
			)
			
			
			
			
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		controls only + FE
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			share_age_0_24 share_age_55plus ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			share_age_0_24 share_age_55plus ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("FE") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
			
	

*==============================================================
*				Table 001: Trust
*==============================================================


reg  ue2_hyst ///
			WVS_index_2 ///
			[aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
	
outreg2  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("OLS") dec(2) nocons addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			WVS_index_2 ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		+ controls 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			WVS_index_2   ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			share_age_0_24 share_age_55plus ///
			year_school hh_size home_own_rate  netmig_rate ///	(OTHER CONTROLS)	
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  /// (OTHER CONTROLS)
			logY_ppp   urban_share_500_y1990 mlog_road_density city_nuts capital /// (OTHER CONTROLS)
			turnmig_rate  ///
			)
			
			
			
			
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		controls only + FE
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("FE") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
			

			
*=================================================================
* 				all included			
*=================================================================

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		+ controls 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			[aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("OLS") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school hh_size home_own_rate  netmig_rate ///	(OTHER CONTROLS)	
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  /// (OTHER CONTROLS)
			logY_ppp   urban_share_500_y1990 mlog_road_density city_nuts capital /// (OTHER CONTROLS)
			turnmig_rate  ///
			)
			
			
			
			
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*		controls only + FE
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			cid_* [aw=pop_wgt]  if smpl2==1, robust beta 

* BIC 
local BIC=(-2*e(ll)+e(df_m)*log(e(N)))/e(N)	
			  
outreg2  ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///			
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			append	dta ctitle("FE") dec(2)  nocons  addstat(BIC, `BIC') ///
			sortvar( ///
			turnmig_rate ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector  ///
			ic_EMP_share_female  hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)
			
			
			
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
outreg2  ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\outreg_tables\table4002", ///
			groupvar( ///
			turnmig_rate   ///
			share_age_0_24 share_age_55plus ///	
			WVS_index_2  ///
			Controls ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density city_nuts capital ///
			)	
			
	
		
log close
	

	
